/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.base.Function;
import org.python.google.common.base.Objects;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.Collections2;
import org.python.google.common.collect.Sets;
import org.python.google.common.collect.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@Beta
public final class Tables {
    private Tables() {
    }

    public static <R, C, V> Table.Cell<R, C, V> immutableCell(@Nullable R r, @Nullable C c, @Nullable V v) {
        return new ImmutableCell<R, C, V>(r, c, v);
    }

    public static <R, C, V> Table<C, R, V> transpose(Table<R, C, V> table) {
        return table instanceof TransposeTable ? ((TransposeTable)table).original : new TransposeTable<C, R, V>(table);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractCell<R, C, V>
    implements Table.Cell<R, C, V> {
        AbstractCell() {
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)object;
                return Objects.equal(this.getRowKey(), cell.getRowKey()) && Objects.equal(this.getColumnKey(), cell.getColumnKey()) && Objects.equal(this.getValue(), cell.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getRowKey(), this.getColumnKey(), this.getValue());
        }

        public String toString() {
            return "(" + this.getRowKey() + "," + this.getColumnKey() + ")=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableCell<R, C, V>
    extends AbstractCell<R, C, V>
    implements Serializable {
        final R rowKey;
        final C columnKey;
        final V value;
        private static final long serialVersionUID = 0L;

        ImmutableCell(@Nullable R r, @Nullable C c, @Nullable V v) {
            this.rowKey = r;
            this.columnKey = c;
            this.value = v;
        }

        @Override
        public R getRowKey() {
            return this.rowKey;
        }

        @Override
        public C getColumnKey() {
            return this.columnKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransposeTable<C, R, V>
    implements Table<C, R, V> {
        final Table<R, C, V> original;
        private static final Function TRANSPOSE_CELL = new Function(){

            public Object apply(Object object) {
                Table.Cell cell = (Table.Cell)object;
                return Tables.immutableCell(cell.getColumnKey(), cell.getRowKey(), cell.getValue());
            }
        };
        CellSet cellSet;

        TransposeTable(Table<R, C, V> table) {
            this.original = Preconditions.checkNotNull(table);
        }

        @Override
        public void clear() {
            this.original.clear();
        }

        @Override
        public Map<C, V> column(R r) {
            return this.original.row(r);
        }

        @Override
        public Set<R> columnKeySet() {
            return this.original.rowKeySet();
        }

        @Override
        public Map<R, Map<C, V>> columnMap() {
            return this.original.rowMap();
        }

        @Override
        public boolean contains(@Nullable Object object, @Nullable Object object2) {
            return this.original.contains(object2, object);
        }

        @Override
        public boolean containsColumn(@Nullable Object object) {
            return this.original.containsRow(object);
        }

        @Override
        public boolean containsRow(@Nullable Object object) {
            return this.original.containsColumn(object);
        }

        @Override
        public boolean containsValue(@Nullable Object object) {
            return this.original.containsValue(object);
        }

        @Override
        public V get(@Nullable Object object, @Nullable Object object2) {
            return this.original.get(object2, object);
        }

        @Override
        public boolean isEmpty() {
            return this.original.isEmpty();
        }

        @Override
        public V put(C c, R r, V v) {
            return this.original.put(r, c, v);
        }

        @Override
        public void putAll(Table<? extends C, ? extends R, ? extends V> table) {
            this.original.putAll(Tables.transpose(table));
        }

        @Override
        public V remove(@Nullable Object object, @Nullable Object object2) {
            return this.original.remove(object2, object);
        }

        @Override
        public Map<R, V> row(C c) {
            return this.original.column(c);
        }

        @Override
        public Set<C> rowKeySet() {
            return this.original.columnKeySet();
        }

        @Override
        public Map<C, Map<R, V>> rowMap() {
            return this.original.columnMap();
        }

        @Override
        public int size() {
            return this.original.size();
        }

        @Override
        public Collection<V> values() {
            return this.original.values();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Table) {
                Table table = (Table)object;
                return ((Object)this.cellSet()).equals(table.cellSet());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.cellSet()).hashCode();
        }

        public String toString() {
            return this.rowMap().toString();
        }

        @Override
        public Set<Table.Cell<C, R, V>> cellSet() {
            CellSet cellSet = this.cellSet;
            return cellSet == null ? (this.cellSet = new CellSet()) : cellSet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CellSet
        extends Collections2.TransformedCollection<Table.Cell<R, C, V>, Table.Cell<C, R, V>>
        implements Set<Table.Cell<C, R, V>> {
            CellSet() {
                super(TransposeTable.this.original.cellSet(), TRANSPOSE_CELL);
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                if (set.size() != this.size()) {
                    return false;
                }
                return this.containsAll(set);
            }

            @Override
            public int hashCode() {
                return Sets.hashCodeImpl(this);
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Table.Cell) {
                    Table.Cell cell = (Table.Cell)object;
                    return TransposeTable.this.original.cellSet().contains(Tables.immutableCell(cell.getColumnKey(), cell.getRowKey(), cell.getValue()));
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                if (object instanceof Table.Cell) {
                    Table.Cell cell = (Table.Cell)object;
                    return TransposeTable.this.original.cellSet().remove(Tables.immutableCell(cell.getColumnKey(), cell.getRowKey(), cell.getValue()));
                }
                return false;
            }
        }
    }
}

